/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.sysutils.OperatingSystem;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WSLogger {
    private static final String DEFAULT_WS_LOGFILE_WIN = "c:\\wsinvoke.log";
    private static final String DEFAULT_WS_LOGFILE = "wsinvoke.log";
    private static String EOL = System.getProperty("line.separator", "\n");
    private static boolean bWindowsOS = OperatingSystem.isWindows();
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.S");
    private static SimpleDateFormat fileDateFormatter = new SimpleDateFormat(".yyyy_MM_dd_HH_mm");
    protected static Logger logger = Logger.getLogger("filenet.vw.utils");
    private String m_fileName = null;
    private long m_fileSize = 5000000L;
    private String m_type = null;
    private boolean m_traceToFile = true;
    public static String DEFAULT_FILENAME = null;
    private Date startTime = new Date();
    private StringBuffer buf = new StringBuffer();

    public static String _get_FILE_DATE() {
        return "$Date:   05 Aug 2005 11:46:44  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    public void setType(String s) {
        this.m_type = s;
    }

    public void setTraceToFile(boolean bval) {
        this.m_traceToFile = bval;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public void setFileSize(long size) {
        if (size > 0L) {
            this.m_fileSize = size;
        }
    }

    public WSLogger(String type) {
        this.m_type = type;
        this.m_fileName = DEFAULT_FILENAME;
    }

    private void clear() {
        this.buf.delete(0, this.buf.length());
    }

    public WSLogger eoln() {
        this.buf.append(EOL);
        return this;
    }

    public WSLogger append(Object obj) {
        if (obj == null) {
            this.buf.append("null");
            return this;
        }
        if (!obj.getClass().isArray()) {
            this.buf.append(obj);
        } else {
            Object[] objArray = (Object[])obj;
            if (objArray != null) {
                int nItems = objArray.length;
                for (int i = 0; i < nItems; ++i) {
                    this.append(objArray[i]).eoln();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print(String text) {
        PrintStream outFile = null;
        try {
            try {
                String outText = null;
                if (text != null) {
                    this.buf.append(text);
                }
                if (this.buf.length() == 0) {
                    Object var5_5 = null;
                    if (outFile == null) return;
                    outFile.close();
                    return;
                }
                outText = dateFormatter.format(this.startTime) + "\t" + this.m_type + EOL + this.buf.toString();
                this.clear();
                if (this.m_traceToFile) {
                    outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.m_fileName, true)));
                    outFile.println(outText);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Web Services", this.m_type, outText);
                }
            }
            catch (Exception exception) {
                Object var5_7 = null;
                if (outFile == null) return;
                outFile.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (outFile != null) {
                outFile.close();
            }
            outFile = null;
            throw throwable;
        }
        Object var5_6 = null;
        if (outFile == null) return;
        outFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String text) {
        PrintStream outFile = null;
        try {
            block14: {
                try {
                    String outText = null;
                    if (text != null) {
                        this.buf.append(text);
                    } else {
                        this.buf.append(this.m_type).append(" finished");
                    }
                    this.buf.append(" TOOK ").append(new Date().getTime() - this.startTime.getTime()).append("ms");
                    outText = dateFormatter.format(this.startTime) + "\t" + this.m_type + EOL + this.buf.toString() + EOL;
                    this.clear();
                    if (this.m_traceToFile) {
                        outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.m_fileName, true)));
                        outFile.println(outText);
                        outFile.close();
                        outFile = null;
                        File f = new File(this.m_fileName);
                        if (f.length() > this.m_fileSize) {
                            String newFileName = this.m_fileName + fileDateFormatter.format(this.startTime);
                            boolean ok = false;
                            File newF = null;
                            int count = 0;
                            while (!ok && count < 10) {
                                newF = new File(newFileName);
                                if (newF.exists()) {
                                    newFileName = this.m_fileName + fileDateFormatter.format(this.startTime) + "." + Integer.toString(count++);
                                    newF = null;
                                    continue;
                                }
                                ok = true;
                            }
                            if (newF != null) {
                                f.renameTo(newF);
                            }
                        }
                    }
                    if (!logger.isLoggable(Level.FINEST)) break block14;
                    logger.finest("Web Services", this.m_type, outText);
                }
                catch (Exception exception) {
                    Object var10_11 = null;
                    if (outFile != null) {
                        outFile.close();
                    }
                    outFile = null;
                }
            }
            Object var10_10 = null;
            if (outFile != null) {
                outFile.close();
            }
            outFile = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (outFile != null) {
                outFile.close();
            }
            outFile = null;
            throw throwable;
        }
    }

    static {
        DEFAULT_FILENAME = bWindowsOS ? DEFAULT_WS_LOGFILE_WIN : DEFAULT_WS_LOGFILE;
    }
}

